#include "wifi.h"
extern uint8_t CONNECT_FLEG;
void WIFI_BUFF_MEMSET(void)
{
	memset(wifi.BUFF,0,BUFF_MAX);
	wifi.buff_flag = 0;
	wifi.buff_length = 0;
}

void WIFI_SEND(u8 *data)
{
	USART1_SEND(data,strlen((char *)data));
}
/**
 * ܣWIFIӦ
 * 
 *			 srcWIFIյݵĻ
 *       destҪӦź
 *       timeout: ȴӦźŵĲѯʱʱ
 * ֵ
        1 ָɹ
		0 Ӧʱ
 *				 						
 */
uint8_t WIFI_CheckAck(char* src, char* dest, int timeout)
{
	char *check = NULL;
	//ջ
	 WIFI_BUFF_MEMSET();
	
	 WIFI_SEND(src);
	 
	 while(timeout--)
	 {
		delay_ms(1);//ʱ1ms
		if(wifi.buff_flag==1)
		 {
			check = strstr(wifi.BUFF,dest);
			if(check != NULL)
				return 1; 
			WIFI_BUFF_MEMSET();// 		
		 }

	 }
	 return 0;//ʱ	
}

/**
 * ܣTCPͨ
 * 
 *		 id:WIFI
 *       password:WIFI
 * ֵ
        1 ָɹ
		0 Ӧʱ
 *				 						
 */
void CONNECT_TO_TCP(u8* id,u8 *password)
{
	u8 buf[50];
	WIFI_CheckAck("+++",id,1500); //ȷ˳͸
	while(!WIFI_CheckAck("AT+RESTORE\r\n","OK",5000));
	while(!WIFI_CheckAck("AT\r\n","OK",1000));
	while(!WIFI_CheckAck("AT+CWMODE=0\r\n","OK",2000)); 
	sprintf((char *)buf,"AT+CWJAP=%s,%s\r\n",id,password);
	while(!WIFI_CheckAck((char *)buf,"+CWJAP:1,",5000));
	while(!WIFI_CheckAck("AT+CIPMODE=1\r\n","OK",1000)!=0);
	while(!WIFI_CheckAck("AT+CIPSTART=TCP,192.168.0.223,2347\r\n","+CIPSTART:1",3000));
	while(!WIFI_CheckAck("AT+CIPSEND\r\n","OK",1000));
	WIFI_SEND(":Connected\r\n");
	CONNECT_FLEG = 1;
}

void CONNECT_TO_UDP(u8* id,u8 *password)
{
	u8 buf[50];

	WIFI_CheckAck("+++",id,1500); //ȷ˳͸
	while(!WIFI_CheckAck("AT+RESTORE\r\n","OK",5000));
	while(!WIFI_CheckAck("AT\r\n","OK",1000));
	while(!WIFI_CheckAck("AT+CWMODE=0\r\n","OK",2000)); 
	sprintf((char *)buf,"AT+CWJAP=%s,%s\r\n",id,password);
	while(!WIFI_CheckAck((char *)buf,"+CWJAP:1,",5000));
	while(!WIFI_CheckAck("AT+CIPMODE=1\r\n","OK",1000)!=0);
	while(!WIFI_CheckAck("AT+CIPSTART=UDP,192.168.0.146,2345,1112,0\r\n","+CIPSTART:1",3000)); //192.168.0.150,2345ΪIPַ 2345 ˿ں1112 ģõĶ˿ں 0 UDP̶Ŀģʽ 
	while(!WIFI_CheckAck("AT+CIPSEND\r\n","OK",1000));
	WIFI_SEND(":Connected\r\n");
	CONNECT_FLEG = 1;
}
void CONNECT_TO_MQTT(u8* id,u8 *password)
{
	u8 buf[50];
	WIFI_CheckAck("AT+MQTTCLEAN\r\n","OK",1000);
	while(!WIFI_CheckAck("AT+RESTORE\r\n","OK",5000));
	while(!WIFI_CheckAck("AT\r\n","OK",1000));
	while(!WIFI_CheckAck("AT+CWMODE=0\r\n","OK",2000)); //STAģʽ
	sprintf((char *)buf,"AT+CWJAP=%s,%s\r\n",id,password);
	while(!WIFI_CheckAck((char *)buf,"+CWJAP:1,",5000));//WIFI
	while(!WIFI_CheckAck("AT+MQTTLONGCLIENTID=WF-TEST2\r\n","OK",1000)!=0);// MQTT ͻĿͻ IDû
	while(!WIFI_CheckAck("AT+MQTTCONN=broker.emqx.io,1883,0\r\n","MQTTCONNECTED:",2000)!=0);// MQTT 
	while(!WIFI_CheckAck("AT+MQTTSUB=test-app,0\r\n","OK",2000)!=0);// test-app
	while(!WIFI_CheckAck("AT+MQTTPUBRAW=test-w,32,0,0\r\n","OK",2000)!=0);
	WIFI_SEND("MQTT_Connected\r\n");
	WIFI_BUFF_MEMSET();
	CONNECT_FLEG = 1;
}
/****************************************
 *  Ļʾ OLED_SHOW()  
 *                                      
 * ˵   ȸƼ
 *            WF24 
*****************************************/
void  OLED_SHOW()
{
		OLED_ShowChinese(10,0,0,16,1); 
		OLED_ShowChinese(28,0,1,16,1);
		OLED_ShowChinese(44,0,2,16,1);
		OLED_ShowChinese(62,0,3,16,1);
		OLED_ShowChinese(80,0,4,16,1);
		OLED_ShowChinese(98,0,5,16,1);
	  OLED_ShowString(44,16,"WF24",16,1);
		OLED_Refresh();
}
/****************************************
 *  жϺ WIFI_Config()    
 *                                      
 *  LED1  LEDأ2
 *  
 *  OLED3  OLEDأ4
 *
 *  ת5  ת6 
*****************************************/
u8 Flag = 1;                  //ͻӱ־λ
void wifi_rx_Control(void)
{
		char *ptr = NULL;
		u8  number;
		if(wifi.buff_flag == 1)
		{
			if(strstr((char *)wifi.BUFF,"192.168.0")!=NULL)     //˽ж
			{
						ptr = strrchr((char*)wifi.BUFF,',');           // һ,Ϊ׼Ϊ

					  if(strlen(ptr)-3==1)                      //жϽյΪһλ   ,*\r\n
						{
							number = ptr[1]-'0';
							switch(number)
							{
							 case 1: LED_OFF();  break;
							 case 2: LED_ON();   break;
							 case 3:OLED_SHOW(); break;
							 case 4:OLED_Clear();break;
							 case 5:Motor_Control1(); break;
							 case 6:Motor_Control2(); break;
							 case 7:Motor_Control3(); break;
							 default:  return;
							}						 
						}
			 }  
			 else if(strstr((char *)wifi.BUFF,"RECV:test-app")!=NULL)
			{
				ptr = strrchr((char*)wifi.BUFF,',');           // һ,Ϊ׼Ϊ

						  if(strlen(ptr)-3==1)                      //жϽյΪһλ   ,*\r\n
							{
								number = ptr[1]-'0';
								switch(number)
								{
								 case 1: LED_OFF();  break;
								 case 2: LED_ON();   break;
								 case 3:OLED_SHOW(); break;
								 case 4:OLED_Clear();break;
								 case 5:Motor_Control1(); break;
								 case 6:Motor_Control2(); break;
								 case 7:Motor_Control3(); break;
								 default:  return;
								}						 
							}
				
			}
		}
		
		WIFI_BUFF_MEMSET();
}







