#include "UART.h"
#include <string.h>
#include "oled.h"
#include <stdio.h>

// ڴ洢ݵ
unsigned char rxBuffer[ARRAY_SIZE];
unsigned int rxIndex = 0;  // ݵ
unsigned int rx_flag=0;
extern unsigned int  CONNECT_FLEG;//ӱ־
// ʼ
void Serial_Init() {
    SCON = 0x50;  // Ϊģʽ18λݣɱ䲨
    TMOD &= 0x0F;  // ʱ1ģʽλ
    TMOD |= 0x20;  // öʱ1Ϊ8λԶװģʽ
    TH1 = TL1 = 256 - (11059200 / 12 / 32) / BAUDRATE;  // ò
    TR1 = 1;       // ʱ1
    ES = 1;        // ж
    EA = 1;        // ȫж
}

void Delay(unsigned int xms)
{
	unsigned char i, j;
	while(xms--)
	{
		i = 2;
		j = 239;
		do
		{
			while (--j);
		} while (--i);
	}
}

void buff_memset(void)
{
	memset(rxBuffer,0,64);
	rxIndex=0;
	rx_flag = 0;
}
unsigned int  WIFI_CheckAck(char* src, char* dest, int timeout)
{
	char *check = NULL;
	//ջ
	 buff_memset();
	
	 UART_sentString(src);
	 timeout=timeout/10;//10msһ
	 while(timeout--)
	 {
		Delay(10);//ʱ1ms
		if(rx_flag==1)
		 {
			check = strstr(rxBuffer,dest);
			if(check != NULL)
			{
				buff_memset();// 		
				return 1; 
			}
		 }
	 }
	 buff_memset();// 	
	 return 0;//ʱ	
}

sbit LED = P2^5;
sbit motor1 = P2^6;
sbit motor2 = P2^7;

void CONNECT_TX_Control(void)
{
	char *ptr = NULL;
	int number;
	if (CONNECT_FLEG) 
	{
		if(rx_flag)
		{
			if(strstr(rxBuffer,"192.168.0")!=NULL)
			{
				ptr = strrchr((char*)rxBuffer,',');           // һ,Ϊ׼Ϊ
				
				if(strlen(ptr)-3==1)                      //жϽյΪһλ   ,*\r\n
						{
							number = ptr[1]-'0';
							switch(number)
							{
							 case 1: LED = 0 ; break;
							 case 2: LED = 1; break;
							 case 3:OLED_Show(); break;
							 case 4:OLED_Clear(); break;
							 case 5:motor1=0;motor2=1; break;
							 case 6:motor1=1;motor2=0; break;
							 case 7:motor1=0;motor2=0 ; break;
							 default:  return;
							}
						}							
			}
			else if(strstr((char *)rxBuffer,"RECV:test-app")!=NULL)
			{
				ptr = strrchr((char*)rxBuffer,',');           // һ,Ϊ׼Ϊ
				
				if(strlen(ptr)-3==1)                      //жϽյΪһλ   ,*\r\n
						{
							number = ptr[1]-'0';
							switch(number)
							{
							 case 1: LED = 0 ; break;
							 case 2: LED = 1; break;
							 case 3:OLED_Show(); break;
							 case 4:OLED_Clear(); break;
							 case 5:motor1=0;motor2=1; break;
							 case 6:motor1=1;motor2=0; break;
							 case 7:motor1=0;motor2=0 ; break;
							 default:  return;
							}
						}
			}
		}
		buff_memset();// 	
	}
}
void CONNECT_TO_TCP(unsigned char* id,unsigned char *password)
{
	unsigned char buf[50];
	WIFI_CheckAck("+++",id,1500); //ȷ˳͸

	while(!WIFI_CheckAck("AT\r\n","OK",1000));
	while(!WIFI_CheckAck("AT+CWMODE=0\r\n","OK",2000)); //STAģʽ
	sprintf((char *)buf,"AT+CWJAP=%s,%s\r\n",id,password);
	while(!WIFI_CheckAck((char *)buf,"+CWJAP:1,",5000));
	while(!WIFI_CheckAck("AT+CIPMODE=1\r\n","OK",1000)!=0);
	while(!WIFI_CheckAck("AT+CIPSTART=TCP,192.168.0.71,2347\r\n","+CIPSTART:1",3000));
	while(!WIFI_CheckAck("AT+CIPSEND\r\n","OK",1000));
	UART_sentString(":Connected\r\n");
	CONNECT_FLEG = 1;
}

void UART_SendByte(unsigned char Byte)
{
	SBUF=Byte;
	while(!TI);
	TI=0;
}

void UART_sentString(char *str)
{
	 
	 while(*str){
		 UART_SendByte(*str);
		 str++;
	 }
}
// ڽжϷ
void Serial_ISR() interrupt 4 {
    if (RI) {
        RI = 0;  // жϱ־
		
		
		rxBuffer[rxIndex++] = SBUF;  // 洢յ
        if(rxBuffer[rxIndex-1]=='\n')
		{
			rx_flag=1;
		}
		if(rxIndex==64)
		{
			rxIndex=0;
			rx_flag=1;
		}
		
    }
}




